#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/


#include "lib/Uniforms.inc"
#include "lib/Common.inc"



const bool colortex6MipmapEnabled = false;



in vec4 texcoord;
in vec3 lightVector;

in float timeSunriseSunset;
in float timeNoon;
in float timeMidnight;
in float timeSkyDark;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSunglow;
in vec3 colorBouncedSunlight;
in vec3 colorScatteredSunlight;
in vec3 colorTorchlight;
in vec3 colorWaterMurk;
in vec3 colorWaterBlue;
in vec3 colorSkyTint;


in vec3 upVector;


#include "lib/GBufferData.inc"

 int v(float v)
 {
   return int(floor(v));
 }
 int t(int f)
 {
   return f-v(mod(float(f),2.))-0;
 }
 int d(int f)
 {
   return f-v(mod(float(f),2.))-1;
 }
 int d()
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int f=m.x*m.y;
   return t(v(floor(pow(float(f),.333333))));
 }
 int t()
 {
   ivec2 m=ivec2(2048,2048);
   int f=m.x*m.y;
   return d(v(floor(pow(float(f),.333333))));
 }
 vec3 r(vec2 v)
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int z=f.x*f.y,y=d();
   ivec2 m=ivec2(v.x*f.x,v.y*f.y);
   float x=float(m.y/y),i=float(int(m.x+mod(f.x*x,y))/y);
   i+=floor(f.x*x/y);
   vec3 r=vec3(0.,0.,i);
   r.x=mod(m.x+mod(f.x*x,y),y);
   r.y=mod(m.y,y);
   r.xyz=floor(r.xyz);
   r/=y;
   r.xyz=r.xzy;
   return r;
 }
 vec2 e(vec3 f)
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int x=d();
   vec3 r=f.xzy*x;
   r=floor(r+1e-05);
   float y=r.z;
   vec2 i;
   i.x=mod(r.x+y*x,v.x);
   float m=r.x+y*x;
   i.y=r.y+floor(m/v.x)*x;
   i+=.5;
   i/=v;
   return i;
 }
 vec3 f(vec2 f)
 {
   vec2 v=f;
   v.xy/=.5;
   ivec2 m=ivec2(2048,2048);
   int x=m.x*m.y,y=t();
   ivec2 r=ivec2(v.x*m.x,v.y*m.y);
   float z=float(r.y/y),i=float(int(r.x+mod(m.x*z,y))/y);
   i+=floor(m.x*z/y);
   vec3 s=vec3(0.,0.,i);
   s.x=mod(r.x+mod(m.x*z,y),y);
   s.y=mod(r.y,y);
   s.xyz=floor(s.xyz);
   s/=y;
   s.xyz=s.xzy;
   return s;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   ivec2 f=ivec2(2048,2048);
   vec3 r=v.xzy*y;
   r=floor(r+1e-05);
   float x=r.z;
   vec2 i;
   i.x=mod(r.x+x*y,f.x);
   float m=r.x+x*y;
   i.y=r.y+floor(m/f.x)*y;
   i+=.5;
   i/=f;
   i.xy*=.5;
   return i;
 }
 vec3 e(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 s(vec3 v)
 {
   int f=t();
   v=v-vec3(.5);
   v*=f;
   return v;
 }
 vec3 w(vec3 v)
 {
   int y=d();
   v*=1./y;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 p(vec3 v)
 {
   int f=d();
   v=v-vec3(.5);
   v*=f;
   return v;
 }
 vec3 e()
 {
   vec3 v=cameraPosition.xyz+.5,f=previousCameraPosition.xyz+.5,y=floor(v-.0001),i=floor(f-.0001);
   return y-i;
 }
 vec3 m(vec3 v)
 {
   vec4 f=vec4(v,1.);
   f=shadowModelView*f;
   f=shadowProjection*f;
   f/=f.w;
   float x=sqrt(f.x*f.x+f.y*f.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   f.xy*=.95f/y;
   f.z=mix(f.z,.5,.8);
   f=f*.5f+.5f;
   f.xy*=.5;
   f.xy+=.5;
   return f.xyz;
 }
 vec3 d(vec3 v,vec3 f,vec3 y,vec3 x,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 r=m(v);
   float z=.5;
   vec3 i=vec3(1.)*shadow2DLod(shadowtex0,vec3(r.xy,r.z-.0006*z),0).x;
   i*=saturate(dot(f,y));
   {
     vec4 s=texture2DLod(shadowcolor1,r.xy-vec2(0.,.5),4);
     float h=abs(s.x*256.-(v.y+cameraPosition.y)),p=GetCausticsComposite(v,f,h),o=shadow2DLod(shadowtex0,vec3(r.xy-vec2(0.,.5),r.z+1e-06),4).x;
     i=mix(i,i*p,1.-o);
   }
   i=TintUnderwaterDepth(i);
   return i*(1.-rainStrength);
 }
 vec3 e(vec3 v,vec3 f,vec3 y,vec3 x,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 r=s(v),i=m(r+y*.99);
   float z=.5;
   vec3 c=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*z),3).x;
   c*=saturate(dot(f,y));
   c=TintUnderwaterDepth(c);
   return c*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 f,vec3 y,vec3 x,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 r=m(v);
   float z=.5;
   vec3 i=vec3(1.)*shadow2DLod(shadowtex0,vec3(r.xy,r.z-.0006*z),2).x;
   i*=saturate(dot(f,y));
   i=TintUnderwaterDepth(i);
   return i*(1.-rainStrength);
 }struct GITemporalData2{float cNuyPQlxuC;float ZFucbkcOTp;float vfyvrzqkzI;float xSSGSkZnBe;vec3 MXlHQOttjo;};
 vec4 x(GITemporalData2 v)
 {
   vec4 f;
   v.MXlHQOttjo=max(vec3(0.),v.MXlHQOttjo);
   f.x=v.cNuyPQlxuC;
   v.MXlHQOttjo=pow(v.MXlHQOttjo,vec3(.25));
   f.y=PackTwo16BitTo32Bit(v.MXlHQOttjo.x,v.vfyvrzqkzI);
   f.z=PackTwo16BitTo32Bit(v.MXlHQOttjo.y,v.xSSGSkZnBe);
   f.w=PackTwo16BitTo32Bit(v.MXlHQOttjo.z,v.ZFucbkcOTp);
   return f;
 }
 GITemporalData2 h(vec4 v)
 {
   GITemporalData2 f;
   vec2 r=UnpackTwo16BitFrom32Bit(v.y),m=UnpackTwo16BitFrom32Bit(v.z),i=UnpackTwo16BitFrom32Bit(v.w);
   f.cNuyPQlxuC=v.x;
   f.vfyvrzqkzI=r.y;
   f.xSSGSkZnBe=m.y;
   f.ZFucbkcOTp=i.y;
   f.MXlHQOttjo=pow(vec3(r.x,m.x,i.x),vec3(4.));
   return f;
 }
 GITemporalData2 n(vec2 v)
 {
   vec2 f=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*f;
   return h(texture2DLod(colortex5,v,0));
 }
 float h(float v,float y)
 {
   float f=1.;
   #ifdef FULL_RT_REFLECTIONS
   f=clamp(pow(v,.125)+y,0.,1.);
   #else
   f=clamp(v*10.-7.,0.,1.);
   #endif
   return f;
 }
 void d(inout float v,inout float f,float y,float i,vec3 r,float t)
 {
   v*=mix(2.4,2.4,i);
   float x=dot(r,vec3(1.));
   f*=1.-pow(i,.4);
   f/=y*.1+2e-06;
   f*=4.;
   f*=.6;
   float z=y/(x+1e-07)*.2+4e-08;
   z=min(z,1.);
   z=mix(z,1.,pow(i,.25));
   if(t<.12)
     f=0.;
 }
 float d(vec3 v,vec3 y,float f)
 {
   float i=dot(abs(v-y),vec3(.3333));
   i*=f;
   i*=.18;
   return i;
 }
 void e(inout vec3 v,vec2 f,vec3 y)
 {}
 float m(float v,float f)
 {
   return v/(f*20.01+1.);
 }
 float n(float v,float f)
 {
   return exp(-pow(v/(.9*f),2.));
 }
 float p(vec3 v,vec3 y)
 {
   return dot(abs(v-y),vec3(.3333));
 }
 vec3 c(vec2 v)
 {
   vec2 f=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 y[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   f=(floor(f*64.)+.5)/64.;
   vec3 i=texture2D(noisetex,f).xyz,r=vec3(sqrt(.2),sqrt(2.),1.61803);
   i=mod(i+vec3(r)*mod(frameCounter,64.f),vec3(1.));
   return i;
 }
 vec3 c(float v,float f,float y,vec3 i)
 {
   vec3 r;
   r.x=y*cos(v);
   r.y=y*sin(v);
   r.z=f;
   vec3 x=abs(i.y)<.999?vec3(0,0,1):vec3(1,0,0),z=normalize(cross(i,vec3(0.,1.,1.))),m=cross(z,i);
   return z*r.x+m*r.y+i*r.z;
 }
 vec3 c(vec2 v,float f,vec3 y)
 {
   float i=2*3.14159*v.x,x=sqrt((1-v.y)/(1+(f*f-1)*v.y)),z=sqrt(1-x*x);
   return c(i,x,z,y);
 }
 float i(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 f(in vec2 v,in float f,in vec3 y)
 {
   float r=i(f),z=2*3.14159*v.x,x=pow(v.y,1.f/(r+1.f)),h=sqrt(1-x*x);
   return c(z,x,h,y);
 }
 float a(vec2 v)
 {
   return texture2DLod(colortex3,v,0).w;
 }
 vec4 a(sampler2D v,float f,bool y,float i,float r,float x,float z)
 {
   GBufferData s=GetGBufferData();
   GBufferDataTransparent t=GetGBufferDataTransparent();
   bool d=t.depth<s.depth;
   if(d)
     s.normal=t.normal,s.smoothness=t.smoothness,s.metalness=0.,s.mcLightmap=t.mcLightmap,s.depth=t.depth;
   vec4 o=GetViewPosition(texcoord.xy,s.depth),e=gbufferModelViewInverse*vec4(o.xyz,1.),n=gbufferModelViewInverse*vec4(o.xyz,0.);
   vec3 w=normalize(o.xyz),l=normalize(n.xyz),I=normalize((gbufferModelViewInverse*vec4(s.normal,0.)).xyz);
   float G=GetDepthLinear(texcoord.xy),T=1.-s.smoothness,g=T*T,b=h(s.smoothness,s.metalness);
   int M=0;
   vec4 P=texture2DLod(colortex6,texcoord.xy,M);
   float F=Luminance(P.xyz);
   if(b<.001)
     return P;
   float S=f*.9;
   S*=min(g*15.,1.1);
   S*=mix(P.w,1.,z);
   vec2 C=vec2(0.);
   if(y)
     {
       vec2 U=c(texcoord.xy).xy*.99+.005;
       C=U-.5;
     }
   float U=0.,u=1.1,D=m(i,s.totalTexGrad)/(g+.0001),H=m(r,s.totalTexGrad);
   vec4 L=vec4(0.),B=vec4(0.);
   float Z=0.;
   vec4 O=vec4(vec3(x),1.);
   O.xyz=vec3(.5);
   O.xyz*=P.w*.95+.05;
   float k=s.smoothness;
   int W=0;
   for(int Q=-1;Q<=1;Q++)
     {
       for(int j=-1;j<=1;j++)
         {
           vec2 X=(vec2(Q,j)+C)/vec2(viewWidth,viewHeight)*S,q=texcoord.xy+X.xy;
           float A=length(X*vec2(viewWidth,viewHeight));
           q=clamp(q,4./vec2(viewWidth,viewHeight),1.-4./vec2(viewWidth,viewHeight));
           vec4 V=texture2DLod(colortex6,q,M);
           vec3 N=GetNormals(q);
           float R=GetDepthLinear(q),E=pow(saturate(dot(s.normal,N)),D),Y=exp(-(abs(R-G)*u)),K=exp(-(p(V.xyz,P.xyz)*U)),J=exp(-abs(k-a(q))*H),ab=E*Y*K*J;
           L+=vec4(pow(length(V.xyz),O.x)*normalize(V.xyz+1e-05),V.w)*ab;
           Z+=ab;
           B+=V;
           W++;
         }
     }
   L/=Z+.0001;
   L.xyz=pow(length(L.xyz),1./O.x)*normalize(L.xyz+1e-06);
   vec4 V=L;
   if(Z<.001)
     V=P;
   return V;
 }
 void main()
 {
   vec4 v=a(colortex6,15.,false,180.,40.,.1,0.);
   gl_FragData[0]=vec4(v);
 };





/* DRAWBUFFERS:6 */
